////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/OrchestrationException.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * <p>The {@link InputException} exception is raised when a user-input error arises.</p>
 */
NS_REFINED_FOR_SWIFT
@interface InputException : OrchestrationException

/** Error code attached to the exception  (see OrchestrationErrorCodes.h)*/
@property (nonatomic, readonly) int errorCode;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)new NS_UNAVAILABLE;
- (instancetype)initWithMessage:(NSString *)message errorCode:(int)errorCode;

@end

NS_ASSUME_NONNULL_END
